<?php

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( esc_html__( 'You do not have sufficient capabilities to access this page.', 'dalt' ) );
}

?>

<div class="wrap">

	<h2><?php esc_html_e( 'League Table - Options', 'dalt' ); ?></h2>

	<?php

	//settings errors
	if ( isset( $_GET['settings-updated'] ) ) {
		$settings_updated = sanitize_key($_GET['settings-updated']);
		if($settings_updated === 'true'){
			settings_errors();
		}
	}

	?>

	<div id="daext-options-wrapper">

		<?php

		//get current tab value
		$active_tab = isset( $_GET['tab'] ) ? $_GET['tab'] : 'general';

		?>

		<div class="nav-tab-wrapper">
			<a href="?page=dalt-options&tab=general"
			   class="nav-tab <?php echo $active_tab == 'general' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'General', 'dalt' ); ?></a>
            <a href="?page=dalt-options&tab=cell-properties"
               class="nav-tab <?php echo $active_tab == 'cell-properties' ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'Cell Properties', 'dalt' ); ?></a>
        </div>

		<form method='post' action='options.php'>

			<?php

			if ( $active_tab == 'general' ) {

				settings_fields( $this->shared->get( 'slug' ) . '_general_options' );
				do_settings_sections( $this->shared->get( 'slug' ) . '_general_options' );

			}

			if ( $active_tab == 'cell-properties' ) {

				settings_fields( $this->shared->get( 'slug' ) . '_cell_properties_options' );
				do_settings_sections( $this->shared->get( 'slug' ) . '_cell_properties_options' );

			}

			?>

			<div class="daext-options-action">
				<input type="submit" name="submit" id="submit" class="button"
				       value="<?php esc_attr_e( 'Save Changes', 'dalt' ); ?>">
			</div>

		</form>

	</div>

</div>